require "prefabutil"

chestfunctions = require("scenarios/chestfunctions")

local assets=
{
	--Asset("ANIM", "anim/bird_cage.zip"),
	--Asset("ANIM", "anim/ee_chest.zip"),
	Asset("ANIM", "anim/ui_chest_3x2.zip"),
	Asset("ANIM", "anim/alchemicalresearcher.zip"),
	
	--   Asset("ANIM", "anim/ee_chest.zip"),
	
	Asset("IMAGE", "images/eechestmaker.tex"),
	Asset("ATLAS", "images/eechestmaker.xml"),
}

local chests = {
	ee_chestmaker = {
		--bank="chest",
		--build="ee_chest",
		
		bank="alchemicalresearcher",
		build="alchemical",
	},
}


local function DoIdle(inst)
	if inst.EEhasWork == true then
		
		local recipeitem = inst.components.container:GetItemInSlot(1)
		local costitem = inst.components.container:GetItemInSlot(2)
		
		local outputitem = inst.components.container:GetItemInSlot(3)
		
		if recipeitem and costitem and not outputitem then
			local fEEusedSR = false
			if inst.EEgoldused >= EEchestmakergold then
				if recipeitem.EMCname and costitem.EMCname and costitem.EMCname == "goldnugget" and costitem.components.stackable.stacksize >= 5 then
					
					--secret recipes:
					if recipeitem.EMCname == "darkmatter" then
						--goldenpinecone:
						local outputloot1 = {{"globalsingularity_blueprint",},}
						
						local outputloot2
						if recipeitem.components.stackable.stacksize > 1 then
							outputloot2 = {{item = recipeitem.EMCname,count = recipeitem.components.stackable.stacksize-1,},}
							--chestfunctions.AddChestItems(inst, outputloot2)
						end
						
						local outputloot3
						if costitem.components.stackable.stacksize > 5 then
							outputloot3 = {{item = "goldnugget",count = costitem.components.stackable.stacksize-5,},}
							--chestfunctions.AddChestItems(inst, outputloot3)
						end
						
						chestfunctions.AddChestItems(inst, outputloot1)
						
						--delete Inputs
						recipeitem = inst.components.container:RemoveItemBySlot(1)
						costitem = inst.components.container:RemoveItemBySlot(2)
						recipeitem:Remove()
						costitem:Remove()
						
						if outputloot2 then chestfunctions.AddChestItems(inst, outputloot2) end
						if outputloot3 then chestfunctions.AddChestItems(inst, outputloot3) end
						
						--inst.components.lootdropper:SpawnLootPrefab("eepinecone")
						fEEusedSR = true
						
						inst.EEgoldused = inst.EEgoldused - EEchestmakergold
					end
					
					inst:Lightupdate()
				end
			end
			if fEEusedSR == false then
				if recipeitem.EMChasblueprint and recipeitem.EMCname and recipeitem.EMChasblueprint == true then
					if costitem.EMCname and costitem.EMCname == "goldnugget" and costitem.components.stackable.stacksize >= 5 then
						--creating recipe
						local outputloot1 = {{item = "eeblueprint"},}
						
						--GetPlayer().components.builder:KnowsRecipe(recipeitem.EMCname.."EE")
						
						--inst.components.teacher:SetRecipe(recipeitem.EMCname.."EE")
						--inst.components.teacher:Teach(GetPlayer())
						--chestfunctions.AddChestItems(inst, outputloot1)
						
						local outputloot2
						if recipeitem.components.stackable and recipeitem.components.stackable.stacksize > 1 then
							outputloot2 = {{item = recipeitem.EMCname,count = recipeitem.components.stackable.stacksize-1,},}
							--chestfunctions.AddChestItems(inst, outputloot2)
						end
						
						local outputloot3
						if costitem.components.stackable.stacksize > 5 then
							outputloot3 = {{item = "goldnugget",count = costitem.components.stackable.stacksize-5,},}
							--chestfunctions.AddChestItems(inst, outputloot3)
						end
						
						chestfunctions.AddChestItems(inst, outputloot1)
						local EEblueprint = inst.components.container:GetItemInSlot(3)
						EEblueprint:SetTeach(recipeitem.EMCname)
						
						--delete Inputs
						inst.components.container:RemoveItemBySlot(1)
						inst.components.container:RemoveItemBySlot(2)
						recipeitem:Remove()
						costitem:Remove()
						
						if outputloot2 then chestfunctions.AddChestItems(inst, outputloot2) end
						if outputloot3 then chestfunctions.AddChestItems(inst, outputloot3) end
						
						fEEusedSR = true
						
						inst.EEgoldused = inst.EEgoldused + 5
						
						inst:Lightupdate()
						
					end
				end
			end
			if fEEusedSR == true then
				inst.AnimState:PlayAnimation("opening")
				inst.AnimState:PushAnimation("openidle", true)
			end
		end
		
		
		
		inst.EEhasWork = false
	end
end

local function StopIdling(inst)
    if inst.idletask then
        inst.idletask:Cancel()
        inst.idletask = nil
    end
	inst.EEhasWork = false
end

local function StartIdling(inst)
	local outputitem = inst.components.container:GetItemInSlot(3)
	if not outputitem then
		inst.AnimState:PushAnimation("idle", true)
		inst.EEhasWork = true
		inst.EEfexchange = 1
		if not inst.idletask then
			inst.idletask = inst:DoPeriodicTask(EErecipemakertime, DoIdle)
		end
	end
end



local function onopen(inst)
	StopIdling(inst)
	--inst.AnimState:PushAnimation("idle", true)
	--inst.AnimState:PlayAnimation("open") 
	--inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")
	
	inst:Lightupdate()
end 

local function onclose(inst) 
	--inst.AnimState:PlayAnimation("opening")
	--inst.AnimState:PushAnimation("openidle", true)
	--inst.AnimState:PlayAnimation("close") 
	--inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_close")
	StartIdling(inst)
	
	inst:Lightupdate()
end 

local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	inst.components.container:DropEverything()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")	
	inst:Remove()
end

local function onhit(inst, worker)
	--inst.AnimState:PlayAnimation("idle")
	--inst.AnimState:PlayAnimation("hit")
	inst.components.container:DropEverything()
	--inst.AnimState:PushAnimation("closed", false)
	inst.components.container:Close()
end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("build")
	inst.AnimState:PushAnimation("idle", true)
	--inst.AnimState:PlayAnimation("place")
	--inst.AnimState:PushAnimation("closed", false)
	
	inst:Lightupdate()
end

local slotpos = {}

--Input
table.insert(slotpos, Vector3(80*0-80*2+80, 80*2-80*2+80,0))
table.insert(slotpos, Vector3(80*0-80*2+80, 80*1-80*2+80,0))

--Output
table.insert(slotpos, Vector3(80*0-80*2+80, 80*0-80*2+80,0))
--table.insert(slotpos, Vector3(80*1-80*2+80, 80*0-80*2+80,0))
--table.insert(slotpos, Vector3(80*2-80*2+80, 80*0-80*2+80,0))


local function OnSave(inst, data)
    if inst.EEgoldused then
        data["EEGoUs"] = inst.EEgoldused
    end
end

local function OnLoad(inst, data)
    if data and data["EEGoUs"] then
		print("EEgoldused:"..data["EEGoUs"])
		inst.EEgoldused = data["EEGoUs"]
	else
		print("no EEgoldused")
	end
	
	inst:Lightupdate()
end


local function chest(style)
	local fn = function(Sim)
		local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		inst.entity:AddSoundEmitter()
		--local minimap = inst.entity:AddMiniMapEntity()
		
		--minimap:SetIcon( "birdcage.png" )


		inst:AddTag("structure")
	
		inst.AnimState:SetBank("alchemicalresearcher")
		inst.AnimState:SetBuild("alchemicalresearcher")
		--inst.AnimState:PlayAnimation("idle")
		inst.AnimState:PushAnimation("idle", true)
		
		inst:AddComponent("inspectable")
		inst:AddComponent("container")
		inst.components.container:SetNumSlots(#slotpos)
		
		inst.components.container.onopenfn = onopen
		inst.components.container.onclosefn = onclose
		
		inst.components.container.widgetslotpos = slotpos
		inst.components.container.widgetanimbank = "ui_chest_3x3"
		inst.components.container.widgetanimbuild = "ui_chest_3x3"
		inst.components.container.widgetpos = Vector3(0,200,0)
		inst.components.container.side_align_tip = 160
		
		--inst:AddComponent("teacher")
		 
		inst:AddComponent("lootdropper")
		inst:AddComponent("workable")
		inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
		inst.components.workable:SetWorkLeft(2)
		inst.components.workable:SetOnFinishCallback(onhammered)
		inst.components.workable:SetOnWorkCallback(onhit) 
		
		inst:ListenForEvent( "onbuilt", onbuilt)
		MakeSnowCovered(inst, .01)	
		
		--inst:AddComponent("EEgoldused")
		inst.EEgoldused = 0
		
		inst.hislight = inst.entity:AddLight()
		
		function inst:Lightupdate()
			if inst.EEgoldused >= EEchestmakergold then
			inst.hislight:SetIntensity(0.7)
			inst.hislight:SetRadius(2.2)
			inst.hislight:SetColour(255/255, 100/255, 100/255)
			else
			inst.hislight:SetIntensity(0.3)
			inst.hislight:SetRadius(2)
			inst.hislight:SetColour(1/255, 1/255, 255/255)
			end
		end
		
		--inst:DoTaskInTime(3, function()
		--	inst:Lightupdate()
		--end)
		
		inst.hislight:Enable(true)
		
		--inst.EMCinternvalue = 0
		StartIdling(inst)
		
		inst.OnSave = OnSave
		inst.OnLoad = OnLoad
	
		return inst
	end
	return fn
end



return	Prefab( "common/prefab/eechestmaker", chest("ee_chestmaker"), assets),
		MakePlacer("common/prefab/eechestmaker_placer", "alchemicalresearcher", "alchemicalresearcher", "buildstart")

